/*
 * Decompiled with CFR 0.152.
 */
package DE.siemens.ad.udf;

import CH.ifa.draw.util.StorableInput;
import CH.ifa.draw.util.StorableOutput;
import DE.siemens.ad.logo.model.Block;
import DE.siemens.ad.logo.model.BlockConnector;
import DE.siemens.ad.logo.model.BlockParameter;
import DE.siemens.ad.logo.model.BlockPropertyChangeEvent;
import DE.siemens.ad.logo.model.Hardware;
import DE.siemens.ad.logo.model.HardwareFactory;
import DE.siemens.ad.logo.model.InBlockConnector;
import DE.siemens.ad.logo.model.InBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.Interpreter;
import DE.siemens.ad.logo.model.Logo;
import DE.siemens.ad.logo.model.LogoHardwareFactory;
import DE.siemens.ad.logo.model.MathDetectionParameter;
import DE.siemens.ad.logo.model.OutBlockConnector;
import DE.siemens.ad.logo.model.OutBlockConnectorEnumeration;
import DE.siemens.ad.logo.model.ParameterInBlockConnector;
import DE.siemens.ad.logo.model.ParameterItem;
import DE.siemens.ad.logo.model.ParameterItemList;
import DE.siemens.ad.logo.model.WiringDiagram;
import DE.siemens.ad.logo.model.block.AnalogMathsBlock;
import DE.siemens.ad.logo.model.block.DeputyBlock;
import DE.siemens.ad.logo.model.block.InputBlock;
import DE.siemens.ad.logo.model.block.MathDetectionBlock;
import DE.siemens.ad.logo.model.block.OutputBlock;
import DE.siemens.ad.logo.model.hardware.Logo7;
import DE.siemens.ad.logo.model.visitor.build.CompilerToHardware;
import DE.siemens.ad.logo.model.visitor.build.Visitor;
import DE.siemens.ad.logo.util.DifferenceTableModel;
import DE.siemens.ad.logo.util.Language;
import DE.siemens.ad.logo.util.Logger.ErrorInfo;
import DE.siemens.ad.udf.GuidVersionMgr;
import DE.siemens.ad.udf.UDFBlockFigure;
import DE.siemens.ad.udf.UDFBlockParameter;
import DE.siemens.ad.udf.UDFParameterItem;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UDFBlock
extends Block {
    private static final long serialVersionUID = -5367443695319376315L;
    public static final transient int STATE_NORMAL = 0;
    public static final transient int STATE_OUT_OF_SYNC = 1;
    public static final transient int STATE_NOT_FOUND = 2;
    public static final transient int UDF_SOURCE_LOCATE_FLAG_PC = 0;
    public static final transient int UDF_SOURCE_LOCATE_FLAG_BM = 1;
    protected int validity = 0;
    protected boolean isPwdDestroyed = false;
    protected List<Block> children = new ArrayList<Block>();
    protected DeputyBlock[] fInDeputies;
    protected DeputyBlock[] fOutDeputies;
    protected int fSourceLocateFlag = 0;
    protected transient Vector fBlocksUDFExpansion;
    protected String password;
    protected String encryptedPassword;
    protected String identifier = null;
    private String udfFilePath = "";
    private String comment = "";
    protected static final int RES_FREE = 0;
    protected static final int RES_RESERVED = 1;
    protected static final int RES_ALLOCATED = 2;
    private int state = 0;
    private UDFBlockParameter fUDFBlockParameter = new UDFBlockParameter(this);
    private GuidVersionMgr guidMgr = new GuidVersionMgr();

    public UDFBlock(WiringDiagram diagram) {
        super(diagram);
    }

    public UDFBlock() {
        this(null);
    }

    public UDFBlock(WiringDiagram wd, int inputCount, int outputCount) {
        super(wd);
        this.initInOutDeputyArray(inputCount, outputCount);
    }

    @Override
    protected int getDefaultOrder() {
        return 0;
    }

    @Override
    public String getType() {
        return "UDF";
    }

    @Override
    public int getNumberType() {
        return 25;
    }

    @Override
    public boolean isLeftTerminal() {
        return this.fInDeputies == null || this.fInDeputies.length == 0;
    }

    @Override
    public boolean isRightTerminal() {
        return this.fOutDeputies == null || this.fOutDeputies.length == 0;
    }

    public void setValidity(int validity) {
        this.validity = validity;
    }

    public int getValidity() {
        return this.validity;
    }

    @Override
    public boolean isEqual(Object other) {
        if (!super.isEqual(other)) {
            return false;
        }
        return this.getGuid() == ((UDFBlock)other).getGuid();
    }

    public boolean isUDFSelf(Block blk) {
        boolean isSelf = false;
        if (blk == null || !(blk instanceof UDFBlock)) {
            return isSelf;
        }
        for (GuidVersionMgr.GuidVerPair pair : this.getGuidManager().getGuidMap()) {
            for (GuidVersionMgr.GuidVerPair othPair : ((UDFBlock)blk).getGuidManager().getGuidMap()) {
                if (!pair.equals(othPair)) continue;
                return true;
            }
        }
        for (Block child : ((UDFBlock)blk).getBlocks()) {
            if (!(child instanceof UDFBlock) || !this.isUDFSelf(child)) continue;
            return true;
        }
        return isSelf;
    }

    @Override
    public boolean isAvailable(Hardware hw, List errorList) {
        boolean result = true;
        if (!super.isAvailable(hw, errorList)) {
            return false;
        }
        if (!hw.supports("UDF")) {
            errorList.add(new ErrorInfo(this, "error.convert.block.unknownBlock", hw));
            return false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!(this.children.get(i) instanceof UDFBlock) && !this.children.get(i).isAvailable(hw, errorList)) {
                return false;
            }
            if (!(this.children.get(i) instanceof UDFBlock) || ((UDFBlock)this.children.get(i)).isSubUDFAvailable(hw, errorList)) continue;
            return false;
        }
        return result;
    }

    public boolean isSubUDFAvailable(Hardware hw, List errorList) {
        int inConnectorCount;
        Block block = ((Logo)hw).getSubstitutionBlock(this);
        boolean result = true;
        int numberType = block.getNumberType();
        if (numberType != -1 && block.getNumber() > hw.getMaxResource(0)) {
            errorList.add(new ErrorInfo(this, "error.convert.block.numberTooBig", hw));
            result &= false;
        }
        if (!hw.supports("4BaseBlockInputs") && (inConnectorCount = this.getInConnectorCount()) > 0) {
            InBlockConnector[] connectors = this.getInConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                if (connectors[i].isAvailable(hw, errorList)) continue;
                result &= false;
                break;
            }
        }
        if (this.getParameter() != null && !this.getParameter().isAvailable(hw, errorList)) {
            result &= false;
        }
        if (!hw.supports("userBlockName") && this.getUserDefinedName() != null && this.getUserDefinedName().length() > 0) {
            errorList.add(new ErrorInfo(this, "error.convert.block.userDefinedName", hw));
            result &= false;
        }
        for (int i = 0; i < this.children.size(); ++i) {
            if (!(this.children.get(i) instanceof UDFBlock) && !this.children.get(i).isAvailable(hw, errorList)) {
                result &= false;
                continue;
            }
            if (!(this.children.get(i) instanceof UDFBlock) || ((UDFBlock)this.children.get(i)).isSubUDFAvailable(hw, errorList)) continue;
            result &= false;
        }
        return result;
    }

    @Override
    public boolean isResourceAvailable(WiringDiagram wd) {
        boolean result = true;
        int[] needResources = ((Logo)wd.getHardware()).getSubstitutionBlock(this).getMemoryResources(wd.getHardware());
        needResources[this.getNumberType()] = 1;
        int[] freeResources = wd.getFreeResources();
        for (int i = 0; i < needResources.length; ++i) {
            if (needResources[i] <= freeResources[i]) continue;
            return false;
        }
        return result;
    }

    @Override
    public boolean isResourceAvailable(WiringDiagram wd, ArrayList errorList) {
        boolean result = true;
        int[] needResources = ((Logo)wd.getHardware()).getSubstitutionBlock(this).getMemoryResources(wd.getHardware());
        needResources[this.getNumberType()] = 1;
        int[] freeResources = wd.getFreeResources();
        for (int i = 0; i < needResources.length; ++i) {
            if (needResources[i] <= freeResources[i]) continue;
            String s = Language.getString("hardware." + LogoHardwareFactory.getInstance().getResourceNames()[i], "Resource");
            s = Language.getString("error.notAvailable", "% not available", s);
            errorList.add(new ErrorInfo(this, s, wd.getHardware()));
            return false;
        }
        if (!this.isResourceAvailable4Children(wd)) {
            Object[] params = new String[]{this.getIdentifier()};
            String s = Language.getString("msg.noresourcesudf", "Insufficient resources for UDFBlock: " + this.getIdentifier(), params);
            errorList.add(new ErrorInfo(this, s, wd.getHardware()));
            return false;
        }
        return result;
    }

    @Override
    public int getOutConnectorPosition(OutBlockConnector connector) {
        for (int i = 0; i < this.getOutConnectorCount(); ++i) {
            if (this.fOutConnectors[i] != connector) continue;
            return i;
        }
        return -1;
    }

    @Override
    protected void initInConnectors() {
    }

    @Override
    protected void initOutConnectors() {
    }

    @Override
    public String getNumberPrefix() {
        return "U";
    }

    public void initBlockNumber(boolean allocateChild, boolean allocateNew) {
        super.initBlockNumber();
        if (allocateChild && this.fWiringDiagram != null) {
            this.handleChildBlockNumbers(this.fWiringDiagram, allocateNew);
        }
    }

    @Override
    public void changeNumber(int newNumber) throws IllegalArgumentException {
        if (newNumber > this.fHardware.getMaxResource(25)) {
            if (this.getNumber() == newNumber) {
                return;
            }
            int[] subUDFResourceArr = this.getWiringDiagram().getSubUDFResource();
            if (subUDFResourceArr[newNumber - 1] == 2) {
                throw new IllegalArgumentException("New blocknumber is already allocated.");
            }
            if (this.getNumber() > this.fHardware.getMaxResource(25)) {
                subUDFResourceArr[this.getNumber() - 1] = 0;
            } else {
                int[] resourceArr = this.getWiringDiagram().getNumberResource(25);
                resourceArr[this.getNumber() - 1] = 0;
            }
            subUDFResourceArr[newNumber - 1] = 2;
            this.fBlockNumber = newNumber;
        } else if (this.getNumber() > this.fHardware.getMaxResource(25)) {
            int[] resourceArr = this.getWiringDiagram().getNumberResource(25);
            if (resourceArr[newNumber - 1] == 2) {
                throw new IllegalArgumentException("New blocknumber is already allocated.");
            }
            int[] subUDFResourceArr = this.getWiringDiagram().getSubUDFResource();
            subUDFResourceArr[this.getNumber() - 1] = 0;
            resourceArr[newNumber - 1] = 2;
            this.fBlockNumber = newNumber;
        } else {
            super.changeNumber(newNumber);
        }
    }

    @Override
    public boolean compareTo(Block otherBlock, DifferenceTableModel differences) {
        if (!super.compareTo(otherBlock, differences) && this.getClass() != otherBlock.getClass()) {
            return false;
        }
        UDFBlockParameter param = (UDFBlockParameter)this.getParameter();
        if (param != null) {
            return param.compareTo(otherBlock.getParameter(), differences);
        }
        return true;
    }

    @Override
    public void setNumber(int number) {
        super.setNumber(number);
    }

    public void setIdentifier(String newIdentifier) {
        if (newIdentifier != this.identifier) {
            this.identifier = newIdentifier;
            this.fireBlockNameChangedEvent();
        }
    }

    public String getIdentifier() {
        if (this.identifier == null) {
            this.identifier = "UDFXX" + this.getNumber();
        }
        return this.identifier;
    }

    public String getUDFFilePath() {
        return this.udfFilePath;
    }

    public void setUDFFilePath(String udfFilePath) {
        this.udfFilePath = udfFilePath;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean handleChildBlockNumbers(WiringDiagram wd, boolean allocateNew) {
        boolean numberChanged = false;
        if (this.children == null || this.children.size() == 0) {
            return numberChanged;
        }
        Map<Integer, List<Block>> list = this.sortChildrenByType();
        for (Integer key : list.keySet()) {
            List<Block> blockList = list.get(key);
            int[] freeNumbers = this.correctFreeNumbers(wd.getFreeNumbers(key), key);
            if (blockList.size() > freeNumbers.length) {
                System.out.println("WiringDiagram.insert(Block): NoResource in ResourceArray for " + this);
                return false;
            }
            int[] resourceArr = null;
            resourceArr = key == 25 ? wd.getSubUDFResource() : wd.getNumberResource(key);
            int[] numbers = this.getBlockNumbers(resourceArr, blockList.size(), key);
            for (int i = 0; i < blockList.size(); ++i) {
                int blockNumber = blockList.get(i).getNumber();
                if (blockNumber > resourceArr.length || blockNumber <= 0 || numbers[i] <= 0) {
                    System.out.println("WiringDiagram.insert(Block): NoResource in ResourceArray for " + this);
                    return false;
                }
                if (blockList.get(i).getNumberType() == -1) continue;
                if (allocateNew) {
                    if (blockList.get(i) instanceof AnalogMathsBlock) {
                        this.handleMathDetectRefer(blockList.get(i).getNumber(), numbers[i]);
                    }
                    blockList.get(i).setNumber(numbers[i]);
                    numberChanged = true;
                }
                if (resourceArr[(blockNumber = blockList.get(i).getNumber()) - 1] != 2) {
                    resourceArr[blockNumber - 1] = 2;
                }
                if (!(blockList.get(i) instanceof UDFBlock)) continue;
                numberChanged |= ((UDFBlock)blockList.get(i)).handleChildBlockNumbers(wd, allocateNew);
            }
        }
        return numberChanged;
    }

    private void handleMathDetectRefer(int oldNumer, int newNumber) {
        if (this.getHardware().isBlockNameAvailable("MathDetection")) {
            for (Block block : this.getBlocks()) {
                MathDetectionParameter param;
                if (!(block instanceof MathDetectionBlock) || oldNumer != (param = (MathDetectionParameter)block.getParameter()).getReferencedBlockNumber()) continue;
                param.setReferencedBlockNumber(newNumber);
                block.fireBlockPropertyChangeEvent(new BlockPropertyChangeEvent(this, "param;"));
            }
        }
    }

    public boolean isResourceAvailable4Children(WiringDiagram wd) {
        if (this.children == null || this.children.size() == 0) {
            return true;
        }
        Map<Integer, List<Block>> list = this.sortChildrenByType();
        for (Integer key : list.keySet()) {
            List<Block> blockList = list.get(key);
            int[] freeNumbers = this.correctFreeNumbers(wd.getFreeNumbers(key), key);
            if (blockList.size() > freeNumbers.length) {
                return false;
            }
            int[] resourceArr = null;
            resourceArr = key == 25 ? wd.getSubUDFResource() : wd.getNumberResource(key);
            int[] numbers = this.getBlockNumbers(resourceArr, blockList.size(), key);
            for (int i = 0; i < blockList.size(); ++i) {
                int blockNumber = blockList.get(i).getNumber();
                if (blockNumber > resourceArr.length || blockNumber <= 0 || numbers[i] <= 0) {
                    return false;
                }
                if (!(blockList.get(i) instanceof UDFBlock) || ((UDFBlock)blockList.get(i)).isResourceAvailable4Children(wd)) continue;
                return false;
            }
        }
        return true;
    }

    private int[] correctFreeNumbers(int[] freeNumbers, int type) {
        int[] correctFreeNumbers = new int[freeNumbers.length];
        int j = 0;
        if (type == 10) {
            for (int i = 0; i < freeNumbers.length; ++i) {
                if (freeNumbers[i] == 8 || freeNumbers[i] == 25 || freeNumbers[i] == 26 || freeNumbers[i] == 27) continue;
                correctFreeNumbers[j] = freeNumbers[i];
                ++j;
            }
        } else {
            return freeNumbers;
        }
        int[] returnArr = new int[j];
        System.arraycopy(correctFreeNumbers, 0, returnArr, 0, j);
        return returnArr;
    }

    private int[] getBlockNumbers(int[] resourceArr, int blockCount, int numberType) {
        int[] freeNumbers = new int[resourceArr.length];
        int[] reservedNumbers = new int[resourceArr.length];
        int freeCount = 0;
        int reservedCount = 0;
        for (int i = 0; i < resourceArr.length; ++i) {
            if (numberType == 10 && (i == 7 || i == 24 || i == 25 || i == 26)) {
                reservedNumbers[reservedCount++] = i + 1;
                continue;
            }
            if (resourceArr[i] == 0) {
                freeNumbers[freeCount++] = i + 1;
                continue;
            }
            if (resourceArr[i] != 1) continue;
            reservedNumbers[reservedCount++] = i + 1;
        }
        int[] returnArr = new int[blockCount];
        if (blockCount > freeCount + reservedCount) {
            return returnArr;
        }
        if (blockCount > freeCount) {
            System.arraycopy(freeNumbers, 0, returnArr, 0, freeCount);
            if (freeCount <= 0) {
                System.arraycopy(reservedNumbers, 0, returnArr, 0, blockCount);
            } else {
                System.arraycopy(reservedNumbers, 0, returnArr, freeCount - 1, blockCount - freeCount);
            }
        } else {
            System.arraycopy(freeNumbers, 0, returnArr, 0, blockCount);
        }
        Arrays.sort(returnArr);
        return returnArr;
    }

    private Map<Integer, List<Block>> getSortedChildren() {
        TreeMap<Integer, List<Block>> map = new TreeMap<Integer, List<Block>>();
        Enumeration blockEnum = this.getBlocksUDFExpansion().elements();
        Block block = null;
        while (blockEnum.hasMoreElements()) {
            block = (Block)blockEnum.nextElement();
            int type = block.getNumberType();
            if (type == -2) continue;
            List<Block> typedBlockList = (List)map.get(type);
            if (typedBlockList == null) {
                typedBlockList = new ArrayList<Block>();
                map.put(type, typedBlockList);
            }
            typedBlockList.add(block);
        }
        for (List<Block> typedBlockList : map.values()) {
            Collections.sort(typedBlockList, new Comparator<Block>(){

                @Override
                public int compare(Block o1, Block o2) {
                    return o1.getNumber() - o2.getNumber();
                }
            });
        }
        return map;
    }

    private Map<Integer, List<Block>> sortChildrenByType() {
        TreeMap<Integer, List<Block>> map = new TreeMap<Integer, List<Block>>();
        for (Block block : this.getBlocks()) {
            int type = block.getNumberType();
            if (type == -1 || type == -2) continue;
            ArrayList<Block> typedBlockList = (ArrayList<Block>)map.get(type);
            if (typedBlockList == null) {
                typedBlockList = new ArrayList<Block>();
                map.put(type, typedBlockList);
            }
            typedBlockList.add(block);
        }
        for (List typedBlockList : map.values()) {
            Collections.sort(typedBlockList, new Comparator<Block>(){

                @Override
                public int compare(Block o1, Block o2) {
                    return o1.getNumber() - o2.getNumber();
                }
            });
        }
        return map;
    }

    public Vector getBlocksUDFExpansion() {
        if (this.fBlocksUDFExpansion == null) {
            this.fBlocksUDFExpansion = new Vector();
        } else {
            this.fBlocksUDFExpansion.clear();
        }
        Block blk = null;
        for (int i = 0; i < this.getBlocks().size(); ++i) {
            blk = this.getBlocks().get(i);
            if (blk.getNumberType() == 25) {
                this.fBlocksUDFExpansion.addAll(((UDFBlock)blk).getBlocksUDFExpansion());
                continue;
            }
            this.fBlocksUDFExpansion.add(blk);
        }
        return this.fBlocksUDFExpansion;
    }

    public Map<Integer, List<Block>> getSortedOffspring() {
        ArrayList<Block> list = new ArrayList<Block>();
        this.getNumberedOffspring(list);
        return this.getSortedChildren();
    }

    private void getNumberedOffspring(List<Block> list) {
        list.add(this);
        for (Block block : this.children) {
            if (block.getNumberType() == -1) continue;
            if (block instanceof UDFBlock) {
                ((UDFBlock)block).getNumberedOffspring(list);
                continue;
            }
            list.add(block);
        }
    }

    public int getChildBlockOrder(Block child) {
        Map<Integer, List<Block>> sortedChildren = this.getSortedChildren();
        int type = child.getNumberType();
        if (type == 0) {
            return sortedChildren.get(type).indexOf(child);
        }
        ArrayList blockList = new ArrayList();
        for (Map.Entry<Integer, List<Block>> entry : sortedChildren.entrySet()) {
            if (entry.getKey() == 0) continue;
            blockList.addAll(entry.getValue());
        }
        return blockList.indexOf(child);
    }

    public Block getBlockByOrder(int order, boolean isProgramLine) {
        Map<Integer, List<Block>> sortedChildren = this.getSortedChildren();
        if (isProgramLine) {
            return sortedChildren.get(0).get(order);
        }
        ArrayList blockList = new ArrayList();
        for (Map.Entry<Integer, List<Block>> entry : sortedChildren.entrySet()) {
            if (entry.getKey() == 0) continue;
            blockList.addAll(entry.getValue());
        }
        return (Block)blockList.get(order);
    }

    @Override
    public void setWiringDiagram(WiringDiagram newWiringDiagram) {
        super.setWiringDiagram(newWiringDiagram);
        if (this.children != null && this.children.size() > 0) {
            for (Block block : this.children) {
                block.setWiringDiagram(newWiringDiagram);
            }
        }
        if (this.fInDeputies != null) {
            for (DeputyBlock inDeputy : this.fInDeputies) {
                inDeputy.setWiringDiagram(newWiringDiagram);
            }
        }
        if (this.fOutDeputies != null) {
            for (DeputyBlock outDeputy : this.fOutDeputies) {
                outDeputy.setWiringDiagram(newWiringDiagram);
            }
        }
    }

    public String getVersion() {
        return this.guidMgr.getVersion();
    }

    @Override
    public String getIconName() {
        return "UDFDefaultIcon.gif";
    }

    @Override
    public int getOpcode(Hardware hw, int blockNr) throws IllegalArgumentException {
        return ((Logo7)hw).getUDFRelatedOpcode(this.getName());
    }

    @Override
    public int getOpcode() throws RuntimeException {
        return this.getOpcode(this.getHardware(), 0);
    }

    @Override
    public boolean supportsUserDefinedName() {
        try {
            return this.getWiringDiagram().getHardware().supports("userBlockName");
        }
        catch (NullPointerException e) {
            throw new IllegalStateException("block.supportsUserDefinedName(): Noch keine Hardware definiert");
        }
    }

    public Object clone() {
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(os);
            oos.writeObject(this);
            oos.close();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(os.toByteArray()));
            Object obj = ois.readObject();
            os.close();
            ois.close();
            return obj;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Override
    public Object acceptVisitor(Visitor visitor) {
        if (visitor instanceof CompilerToHardware) {
            return null;
        }
        return super.acceptVisitor(visitor);
    }

    @Override
    public void write(StorableOutput dw) {
        int i;
        super.write(dw);
        dw.writeString(this.getIdentifier());
        dw.writeString(this.getVersion());
        dw.writeLong(this.getGuid());
        dw.writeString(this.getComment());
        dw.writeInt(this.getState());
        dw.writeInt(this.getValidity());
        dw.writeString(this.getPassword());
        dw.writeString(this.getEncryptedPassword());
        dw.writeBoolean(this.isPasswordDestroyed());
        if (this.getBlocks() != null && this.getBlocks().size() > 0) {
            dw.writeInt(this.getBlocks().size());
            for (i = 0; i < this.getBlocks().size(); ++i) {
                dw.writeStorable(this.getBlocks().get(i));
                dw.writeInt(this.getBlocks().get(i).getOutConnectorCount());
                for (int j = 0; j < this.getBlocks().get(i).getOutConnectorCount(); ++j) {
                    dw.writeInt(this.getBlocks().get(i).getOutConnector(j).getLinkedConnectorsCount());
                    InBlockConnectorEnumeration enumeration = this.getBlocks().get(i).getOutConnector(j).getLinkedConnectors();
                    while (enumeration.hasMoreElements()) {
                        dw.writeStorable(enumeration.nextElement());
                    }
                }
            }
        } else {
            dw.writeInt(0);
        }
        if (this.fInDeputies != null) {
            dw.writeInt(this.fInDeputies.length);
            for (i = 0; i < this.fInDeputies.length; ++i) {
                dw.writeStorable(this.fInDeputies[i]);
                dw.writeInt(this.fInDeputies[i].getOutConnector(0).getLinkedConnectorsCount());
                InBlockConnectorEnumeration enumeration = this.fInDeputies[i].getOutConnector(0).getLinkedConnectors();
                while (enumeration.hasMoreElements()) {
                    dw.writeStorable(enumeration.nextElement());
                }
            }
        } else {
            dw.writeInt(0);
        }
        if (this.fOutDeputies != null) {
            dw.writeInt(this.fOutDeputies.length);
            for (i = 0; i < this.fOutDeputies.length; ++i) {
                dw.writeStorable(this.fOutDeputies[i]);
                dw.writeInt(this.fOutDeputies[i].getInConnector(0).getLinkedConnectorsCount());
                OutBlockConnectorEnumeration enumeration = this.fOutDeputies[i].getInConnector(0).getLinkedConnectors();
                while (enumeration.hasMoreElements()) {
                    dw.writeStorable(enumeration.nextElement());
                }
            }
        } else {
            dw.writeInt(0);
        }
    }

    @Override
    public String preInsert(WiringDiagram wd) {
        if (this.getOutConnectorCount() > 0) {
            boolean visibility = wd.isRightTerminal(this);
            for (int i = 0; i < this.getOutConnectorCount(); ++i) {
                if (this.getOutConnector(i) == null) continue;
                this.getOutConnector(i).setVisible(!visibility);
                this.getOutConnector(i).setConnectable(!visibility);
            }
        }
        return null;
    }

    @Override
    public void read(StorableInput dr) throws IOException {
        int j;
        int connectorCnt;
        int i;
        super.read(dr);
        this.setIdentifier(dr.readString());
        this.guidMgr.addGuid(dr.readString(), dr.readLong());
        this.comment = dr.readString();
        this.state = dr.readInt();
        this.validity = dr.readInt();
        this.password = dr.readString();
        this.encryptedPassword = dr.readString();
        this.isPwdDestroyed = dr.readBoolean();
        int count = dr.readInt();
        if (count > 0) {
            this.children = new ArrayList<Block>();
            for (i = 0; i < count; ++i) {
                this.children.add((Block)dr.readStorable());
                connectorCnt = dr.readInt();
                for (j = 0; j < connectorCnt; ++j) {
                    int linkerCnt = dr.readInt();
                    for (int k = 0; k < linkerCnt; ++k) {
                        this.children.get(i).getOutConnector(j).connect((InBlockConnector)dr.readStorable());
                    }
                }
            }
        }
        if ((count = dr.readInt()) >= 0) {
            this.fInDeputies = new DeputyBlock[count];
            for (i = 0; i < count; ++i) {
                this.fInDeputies[i] = (DeputyBlock)dr.readStorable();
                connectorCnt = dr.readInt();
                for (j = 0; j < connectorCnt; ++j) {
                    this.fInDeputies[i].getOutConnector(0).connect((InBlockConnector)dr.readStorable());
                }
            }
        }
        if ((count = dr.readInt()) >= 0) {
            this.fOutDeputies = new DeputyBlock[count];
            for (i = 0; i < count; ++i) {
                this.fOutDeputies[i] = (DeputyBlock)dr.readStorable();
                connectorCnt = dr.readInt();
                for (j = 0; j < connectorCnt; ++j) {
                    this.fOutDeputies[i].getInConnector(0).connect((OutBlockConnector)dr.readStorable());
                }
            }
        }
    }

    @Override
    public String getName() {
        return "UDF";
    }

    @Override
    public String getLocalizedName(boolean withNumber) {
        if (withNumber) {
            StringBuffer result = new StringBuffer(this.getNumberString());
            result.append(" [").append(this.getIdentifier()).append("]");
            return result.toString();
        }
        String blockType = Language.getString(this.getLanguageKey(), this.getName());
        return blockType.toString();
    }

    public void setState(int state) {
        int oldState = this.state;
        this.state = state;
        if (oldState != state) {
            for (Object o : this.fBlockNameChangedListeners) {
                if (!(o instanceof UDFBlockFigure)) continue;
                ((UDFBlockFigure)o).invalidate();
                break;
            }
        }
    }

    public int getState() {
        return this.state;
    }

    public int getInDeputyBlockCount() {
        if (this.fInDeputies == null) {
            return 0;
        }
        return this.fInDeputies.length;
    }

    public int getOutDeputyBlockCount() {
        if (this.fOutDeputies == null) {
            return 0;
        }
        return this.fOutDeputies.length;
    }

    public BlockConnector getFirstBlockInputConnector(InBlockConnector udfInputConnector) {
        InBlockConnector inConnector = null;
        InBlockConnectorEnumeration linkedConnectors = udfInputConnector.getOwner().getOutConnector(0).getLinkedConnectors();
        if (linkedConnectors.hasMoreElements()) {
            inConnector = linkedConnectors.nextElement();
            while (inConnector.getOwner() instanceof DeputyBlock) {
                inConnector = inConnector.getOwner().getOutConnector(0).getLinkedConnectors().nextElement();
            }
        }
        return inConnector;
    }

    public BlockConnector getFirstBlockOutputConnector(OutBlockConnector udfOutputConnector) {
        OutBlockConnector outConnector = udfOutputConnector;
        while (outConnector.getOwner() instanceof DeputyBlock) {
            outConnector = outConnector.getOwner().getInConnector(0).getLinkedConnector();
        }
        return outConnector;
    }

    public OutBlockConnector getBlockOutConnector(OutBlockConnector udfOutputConnector) {
        InBlockConnector inConnector = udfOutputConnector.getOwner().getInConnector(0);
        OutBlockConnector outConnector = inConnector.getLinkedConnector();
        while (outConnector.getOwner() instanceof DeputyBlock) {
            inConnector = outConnector.getOwner().getInConnector(0);
            outConnector = inConnector.getLinkedConnector();
        }
        return outConnector;
    }

    public int[] getConnectorCounts() {
        int[] ret = new int[4];
        ret[0] = this.fInConnectors.length;
        ret[1] = this.fOutConnectors.length;
        return ret;
    }

    public void remove(Block block) {
        this.children.remove(block);
    }

    public boolean isCompatible(UDFBlock target) {
        return false;
    }

    public void setUDFBlockParameter(UDFBlockParameter fUDFBlockParameter) {
        this.fUDFBlockParameter = fUDFBlockParameter;
    }

    public void initInConnectors4EditMode(Vector<Block> inputBlocks) {
        this.fInConnectors = new InBlockConnector[inputBlocks.size() + 1];
        this.fInConnectors[this.fInConnectors.length - 1] = new ParameterInBlockConnector((Block)this, this.fUDFBlockParameter, "Par");
    }

    public void initOutConnectors4EditMode(Vector<Block> outputBlocks) {
        this.fOutConnectors = new OutBlockConnector[outputBlocks.size()];
    }

    public void initInConnectors4UseMode(Vector<Block> inputBlocks) {
        int i;
        this.fInConnectors = new InBlockConnector[inputBlocks.size() + 1];
        this.fInDeputies = new DeputyBlock[inputBlocks.size()];
        this.fInConnectors[this.fInConnectors.length - 1] = new ParameterInBlockConnector((Block)this, this.fUDFBlockParameter, "Par");
        for (i = 0; i < inputBlocks.size(); ++i) {
            InputBlock inputBlock = (InputBlock)inputBlocks.get(i);
            DeputyBlock block = new DeputyBlock(this.fWiringDiagram);
            block.setNumber(inputBlock.getNumber());
            block.setBinaryAnalogType(inputBlock.getOutConnector(0).getSignalType());
            block.setInputType(true);
            this.fInDeputies[i] = block;
            this.fInDeputies[i].setParent(this);
            this.fInDeputies[i].fOutConnectors[0] = inputBlocks.get(i).getOutConnector(0);
            this.fInDeputies[i].fOutConnectors[0].setOwner(this.fInDeputies[i]);
            this.fInDeputies[i].setUserDefinedName(inputBlocks.get(i).getUserDefinedName());
            if (inputBlocks.get(i).getUserDefinedName() != null && !inputBlocks.get(i).getUserDefinedName().equals("")) {
                this.fInDeputies[i].getInConnector(0).setName(inputBlocks.get(i).getUserDefinedName());
                continue;
            }
            this.fInDeputies[i].getInConnector(0).setName(inputBlocks.get(i).getNumberString());
        }
        for (i = 0; i < inputBlocks.size(); ++i) {
            this.fInConnectors[i] = this.fInDeputies[i].getInConnector(0);
        }
    }

    public void initOutConnectors4UseMode(Vector<Block> outputBlocks) {
        int i;
        this.fOutConnectors = new OutBlockConnector[outputBlocks.size()];
        this.fOutDeputies = new DeputyBlock[outputBlocks.size()];
        for (i = 0; i < outputBlocks.size(); ++i) {
            OutputBlock outputBlock = (OutputBlock)outputBlocks.get(i);
            DeputyBlock block = new DeputyBlock(this.fWiringDiagram);
            block.setNumber(outputBlock.getNumber());
            block.setBinaryAnalogType(outputBlock.getInConnector(0).getSignalType());
            block.setInputType(false);
            this.fOutDeputies[i] = block;
            this.fOutDeputies[i].setParent(this);
            this.fOutDeputies[i].setInconnector(outputBlocks.get(i).getInConnector(0));
            this.fOutDeputies[i].getInConnector(0).setOwner(this.fOutDeputies[i]);
            this.fOutDeputies[i].setUserDefinedName(outputBlocks.get(i).getUserDefinedName());
            if (outputBlocks.get(i).getUserDefinedName() != null && !outputBlocks.get(i).getUserDefinedName().equals("")) {
                this.fOutDeputies[i].getOutConnector(0).setName(outputBlocks.get(i).getUserDefinedName());
                continue;
            }
            this.fOutDeputies[i].getOutConnector(0).setName(outputBlocks.get(i).getNumberString());
        }
        for (i = 0; i < outputBlocks.size(); ++i) {
            this.fOutConnectors[i] = this.fOutDeputies[i].fOutConnectors[0];
        }
    }

    public void add(Block block) {
        if (!this.children.contains(block)) {
            this.children.add(block);
        }
    }

    public GuidVersionMgr getGuidManager() {
        return this.guidMgr;
    }

    public long getGuid() {
        return this.guidMgr.getGuid();
    }

    public void setGuidManager(GuidVersionMgr guidMgr) {
        this.guidMgr = guidMgr;
    }

    public List<Block> getBlocks() {
        return this.children;
    }

    public Block getBlockByNumber(int type, int blockNumber) {
        if (type == this.getNumberType() && blockNumber == this.getNumber()) {
            return this;
        }
        for (Block blk : this.children) {
            if (blk.getNumberType() != type || blk.getNumber() != blockNumber) continue;
            return blk;
        }
        return null;
    }

    public void setInputDeputy(int index, DeputyBlock block) {
        this.fInDeputies[index] = block;
        this.fInConnectors[index] = block.getInConnector(0);
        this.fInConnectors[index].setName(block.getName());
    }

    public DeputyBlock getInputDeputy(int index) {
        return this.fInDeputies[index];
    }

    public DeputyBlock[] getInputDeputies() {
        return this.fInDeputies;
    }

    public void setOutputDeputy(int index, DeputyBlock block) {
        this.fOutDeputies[index] = block;
        this.fOutConnectors[index] = block.getOutConnector(0);
        this.fOutConnectors[index].setName(block.getName());
    }

    public int getIndexOfInputDeputy(DeputyBlock deputy) {
        for (int i = 0; i < this.fInDeputies.length; ++i) {
            if (deputy != this.fInDeputies[i]) continue;
            return i;
        }
        return -1;
    }

    public int getIndexOfOutputDeputy(DeputyBlock deputy) {
        for (int i = 0; i < this.fOutDeputies.length; ++i) {
            if (deputy != this.fOutDeputies[i]) continue;
            return i;
        }
        return -1;
    }

    public DeputyBlock getOutputDeputy(int index) {
        return this.fOutDeputies[index];
    }

    public DeputyBlock[] getOutputDeputies() {
        return this.fOutDeputies;
    }

    public boolean isConnected(int inIndex, int outIndex) {
        return false;
    }

    @Override
    public void invalidateOutConnectors() {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).invalidateOutConnectors();
        }
        for (DeputyBlock deputy : this.getInputDeputies()) {
            deputy.invalidateOutConnectors();
        }
        for (DeputyBlock deputy : this.getOutputDeputies()) {
            deputy.invalidateOutConnectors();
        }
    }

    @Override
    public void init(Interpreter interpreter, boolean forceReset) {
        for (int i = 0; i < this.children.size(); ++i) {
            this.children.get(i).init(interpreter, forceReset);
        }
        for (DeputyBlock deputy : this.getInputDeputies()) {
            deputy.init(interpreter, forceReset);
        }
        for (DeputyBlock deputy : this.getOutputDeputies()) {
            deputy.init(interpreter, forceReset);
        }
        this.getParameter().init(interpreter, forceReset);
    }

    @Override
    public int[] getMemoryResources(Hardware hardware) {
        int[] result = new int[HardwareFactory.getInstance().getResourceNames().length];
        int[] resourceConsumptionBlock = null;
        for (int i = 0; i < this.getBlocks().size(); ++i) {
            Block block = this.getBlocks().get(i);
            resourceConsumptionBlock = block.getMemoryResources(hardware);
            for (int j = 0; j < resourceConsumptionBlock.length; ++j) {
                int n = j;
                result[n] = result[n] + resourceConsumptionBlock[j];
            }
        }
        return result;
    }

    public String getConnectorSeq(boolean isInConnector) {
        StringBuffer ret = new StringBuffer("");
        if (isInConnector) {
            InBlockConnector[] connectors = this.getInConnectors();
            for (int i = 0; i < connectors.length - 1; ++i) {
                ret.append(connectors[i].getSignalType() == 0 ? "0" : "1");
            }
        } else {
            OutBlockConnector[] connectors = this.getOutConnectors();
            for (int i = 0; i < connectors.length; ++i) {
                ret.append(connectors[i].getSignalType() == 0 ? "0" : "1");
            }
        }
        return ret.toString();
    }

    public void initInOutDeputyArray(int inCounter, int outCounter) {
        this.fOutConnectors = new OutBlockConnector[outCounter];
        this.fOutDeputies = new DeputyBlock[outCounter];
        if (inCounter < 1) {
            this.fInConnectors = new InBlockConnector[1];
            this.fInDeputies = new DeputyBlock[1];
            this.fInConnectors[0] = new ParameterInBlockConnector((Block)this, this.fUDFBlockParameter, "Par");
        } else {
            this.fInConnectors = new InBlockConnector[inCounter];
            this.fInConnectors[inCounter - 1] = new ParameterInBlockConnector((Block)this, this.fUDFBlockParameter, "Par");
            this.fInDeputies = new DeputyBlock[inCounter - 1];
        }
    }

    public int getSourceLocateFlag() {
        return this.fSourceLocateFlag;
    }

    public void setSourceLocateFlag(int sourceLocateFlag) {
        this.fSourceLocateFlag = sourceLocateFlag;
    }

    public String getPassword() {
        if (this.password == null) {
            this.password = "";
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(String password) {
        this.encryptedPassword = password;
    }

    public boolean isPasswordDestroyed() {
        return this.isPwdDestroyed;
    }

    public void setPasswordDestroyed(boolean isPwdDestroyed) {
        this.isPwdDestroyed = isPwdDestroyed;
    }

    public UDFParameterItem getUDFParaItemByRootParaItem(BlockParameter parameter, int parameterNumber) {
        UDFParameterItem result = null;
        UDFBlockParameter refParameter = (UDFBlockParameter)this.getParameter();
        ParameterItem rootParamItem = parameter.getParameterItem(parameterNumber);
        if (rootParamItem.getParameterValueType() == 3) {
            UDFParameterItem bindedParaItem = this.getUDFParaItemByRootParaItem(parameter, rootParamItem.getMinWidth());
            if (bindedParaItem != null) {
                result = new UDFParameterItem(refParameter, bindedParaItem.getIdentifier() + " " + Language.getString("dialog.parameter.stopwatch.timebase", "Time Base"), rootParamItem.getInstanceForParameter(parameter), 9);
            }
            return result;
        }
        ParameterItemList paraList = refParameter.getParameterItems();
        for (int i = 0; i < paraList.size(); ++i) {
            UDFParameterItem item = (UDFParameterItem)paraList.get(i);
            ParameterItem sourceParameterItem = item.getRootSourceParameterItem();
            if (sourceParameterItem.getParameter() != parameter || sourceParameterItem.getParameterNumber() != parameterNumber) continue;
            result = item;
            break;
        }
        return result;
    }

    public boolean isOpen() {
        int i;
        DeputyBlock[] outdeputies = this.getOutputDeputies();
        Vector<OutBlockConnector> outconns = new Vector<OutBlockConnector>();
        for (i = 0; i < outdeputies.length; ++i) {
            boolean isAdded = false;
            for (int j = 0; j < outconns.size(); ++j) {
                if (!outdeputies[i].getInConnector(0).getLinkedConnector().equals(outconns)) continue;
                isAdded = true;
                break;
            }
            if (isAdded) continue;
            outconns.add(outdeputies[i].getInConnector(0).getLinkedConnector());
        }
        for (i = 0; i < outconns.size(); ++i) {
            boolean isConnected = false;
            InBlockConnectorEnumeration inconns = ((OutBlockConnector)outconns.get(i)).getLinkedConnectors();
            while (inconns.hasMoreElements()) {
                InBlockConnector conn = inconns.nextElement();
                Block owner = conn.getOwner();
                if (owner.getOutConnector(0).getLinkedConnectorsCount() <= 0) continue;
                isConnected = true;
                break;
            }
            if (isConnected) continue;
            return true;
        }
        return false;
    }
}

